<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

use GuzzleHttp\Client;
use Symfony\Component\HttpFoundation\Request;

class MyApiController extends AbstractController
{

    #[Route('/', name: 'login')]
    public function loginApi(): Response
    {

        return $this->render("my_api/login.html.twig");
    }

    #[Route('/app_login', name: 'app_login')]
    public function app_loginApi(Request $request): Response
    {
        $client = new Client([
            'verify' => false,
        ]);
        // Récupérer les informations d'identification de la requête
        $credentials = [
            'email' => $request->request->get('email'),
            'password' => $request->request->get('password')
        ];       

        // Appeler l'API de connexion avec les informations d'identification
        $response = $client->request('POST', 'https://127.0.0.1:8000/api/login', [
            'json' => $credentials
        ]);

        //dd($response->getStatusCode() );
        // Vérifier le code de réponse de l'API
        if ($response->getStatusCode() === Response::HTTP_OK) {
            // L'utilisateur est authentifié avec succès, rediriger vers une autre page
            return $this->redirectToRoute('get_all');
        } else {
            // La connexion a échoué, afficher un message d'erreur           
            return $this->redirectToRoute('login');
        }
    }

    #[Route('/getAll', name: 'get_all')]
    public function consumeApi(): Response
    {
        $client = new Client([
            'verify' => false,
        ]);

        $response = $client->request('GET', 'https://127.0.0.1:8000/api/personne');

        // Traitez la réponse JSON ici
        $data = json_decode($response->getBody()->getContents(), true);

        // Retournez la réponse dans un template ou en JSON
        return $this->render("my_api/index.html.twig", compact('data'));
    }
}
