<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class SessionController extends AbstractController
{
    #[Route('/session', name: 'app_session')]
    public function index(Request $request): Response
    {
        $session = $request->getSession();
        if ($session->has("nbreVisite")) {
            $nbreVisite = $session->get("nbreVisite");
            $session->set("nbreVisite", $nbreVisite + 1);
        } else {
            $session->set("nbreVisite", 1);
        }
        return $this->render('session/index.html.twig');
    }
}
