<?php

namespace App\Repository;

use App\Entity\Personne;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Personne>
 *
 * @method Personne|null find($id, $lockMode = null, $lockVersion = null)
 * @method Personne|null findOneBy(array $criteria, array $orderBy = null)
 * @method Personne[]    findAll()
 * @method Personne[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PersonneRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Personne::class);
    }

        /**
         * @return Personne[] Returns an array of Personne objects
         */
        public function findByPersonnesByAgeInterval($min,$max)
        {
            return $this->createQueryBuilder('p')
                ->andWhere('p.age >= :min')
                ->andWhere('p.age <= :max')
                ->setParameter('min', $min)
                ->setParameter('max', $max)
                ->orderBy('p.age', 'ASC')
                ->setMaxResults(10)
                ->getQuery()
                ->getResult()
            ;
        }


        public function statsPersonnesByAgeInterval($min,$max)
        {
            return $this->createQueryBuilder('p')
            ->select('avg(p.age) ageMoy, count(p.id) as nbrePersonnes')
                ->andWhere('p.age >= :min')
                ->andWhere('p.age <= :max')
                ->setParameter('min', $min)
                ->setParameter('max', $max)
                ->orderBy('p.age', 'ASC')
                ->setMaxResults(10)
                ->getQuery()
                ->getScalarResult()
            ;
        }


    //    public function findOneBySomeField($value): ?Personne
    //    {
    //        return $this->createQueryBuilder('p')
    //            ->andWhere('p.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
